Single-folder PDF Compressor

This folder (`single_app/`) contains a minimal deployable app for cPanel/Passenger.

Files:
- `app.py` - FastAPI app
- `compress.py` - compression helper (Ghostscript fallback + pikepdf)
- `public/index.html` - minimal frontend
- `passenger_wsgi.py` - WSGI wrapper that starts uvicorn and proxies requests
- `requirements.txt` - Python deps

Quick local test:
```bash
python -m venv .venv
source .venv/bin/activate
python -m pip install -r requirements.txt
python -m uvicorn app:app --host 127.0.0.1 --port 8001 --reload
# then test upload
curl -F "file=@/path/to/test.pdf" -F "quality=ebook" http://127.0.0.1:8001/compress -o compressed.pdf
```

Deploy to cPanel:
- Upload `single_app/` contents to your app root folder
- In cPanel Web Applications set Application startup file to `passenger_wsgi.py`
- Install requirements in the app venv and Restart the app
