"""
Passenger WSGI wrapper: start a local uvicorn and proxy requests to it.
"""
import os
import sys
import socket
import time
import subprocess
from urllib.request import Request, urlopen
from urllib.error import URLError, HTTPError

ASGI_HOST = "127.0.0.1"
ASGI_PORT = 8001
ASGI_URL = f"http://{ASGI_HOST}:{ASGI_PORT}"

sys.path.insert(0, os.path.dirname(__file__))

# Minimal helpers
def is_port_open(host, port, timeout=0.5):
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    s.settimeout(timeout)
    try:
        s.connect((host, port)); s.close(); return True
    except Exception:
        return False

def start_uvicorn():
    if is_port_open(ASGI_HOST, ASGI_PORT):
        return True
    py = sys.executable or "/usr/bin/python3"
    cmd = [py, "-m", "uvicorn", "app:app", "--host", ASGI_HOST, "--port", str(ASGI_PORT)]
    try:
        subprocess.Popen(cmd, stdout=open('uvicorn.log','a'), stderr=open('uvicorn.err','a'), start_new_session=True)
    except Exception:
        return False
    for _ in range(10):
        if is_port_open(ASGI_HOST, ASGI_PORT):
            return True
        time.sleep(0.3)
    return False

start_uvicorn()

def application(environ, start_response):
    path = environ.get('PATH_INFO','/')
    qs = environ.get('QUERY_STRING')
    url = ASGI_URL + path + ('?' + qs if qs else '')
    method = environ.get('REQUEST_METHOD','GET')
    headers = {}
    for k,v in environ.items():
        if k.startswith('HTTP_'):
            headers[k[5:].replace('_','-').title()] = v
    if 'CONTENT_TYPE' in environ: headers['Content-Type'] = environ['CONTENT_TYPE']
    try:
        length = int(environ.get('CONTENT_LENGTH','0') or 0)
    except Exception:
        length = 0
    body = environ['wsgi.input'].read(length) if length else None
    req = Request(url, data=body, method=method, headers=headers)
    try:
        with urlopen(req) as res:
            start_response(f"{res.status} {res.reason}", list(res.getheaders()))
            return [res.read()]
    except HTTPError as e:
        start_response(f"{e.code} {e.reason}", [('Content-Type','text/plain')])
        try: return [e.read()]
        except: return [b'']
    except URLError as e:
        start_response('502 Bad Gateway', [('Content-Type','text/plain')])
        return [f"Upstream unreachable: {e}".encode('utf-8')]
    except Exception as e:
        start_response('500 Internal Server Error', [('Content-Type','text/plain')])
        return [str(e).encode('utf-8')]
